$TITLE CPE2C Cobb-Douglas consumer model
$ONTEXT
CPE2Cb_sol.gms
Programmed by Hans Lofgren, IFPRI, November 1999.
Adapted by Rob Davies and Dirk van Seventer, July 2004 and March 2007
Includes price increase simulations
plus reporting sets
$OFFTEXT

SET

 C  commodities
    /AGR-C  agricultural commodity,
     NAGR-C  non-agricultural commodity/
    ;
 ALIAS(C,CP);

PARAMETER
 CONSVAL(C) base-year consumption values (LCU)
 /AGR-C 125, NAGR-C 150/

 INCOME base-year income or expenditure (LCU)
 ;
 INCOME = SUM(C, CONSVAL(C));

DISPLAY INCOME;

PARAMETERS
 beta(C)   share of h-hold consumption spending on commodity c
 p(C)      market price of commodity c (LCU)
 yh        household income (LCU)
 ;
VARIABLE
 QH(C)     quantity of household consumption of c (base-year LCU)
 ;
EQUATION
 HHDEM(C)  consumption demand for commodity c
 ;
 HHDEM(C)..   QH(C) =E= beta(C)*yh/p(C);

MODEL
 CPE2C Cobb-Douglas consumer model
 /HHDEM/
 ;

*================================================
*CALIBRATION=====================================
*================================================

PARAMETERS

*Parameter used to define initial variable levels.
 QH0(C)    quantity of household consumption of c (base-year LCU)

*Parameter used to define base values that are changed in simulations.
 P0(C)      base market price of commodity c (LCU)
 ;

 P0(C)  = 1;
 p(C)   = P0(C);

 yh     = INCOME;

 beta(C)  = CONSVAL(C)/SUM(CP, CONSVAL(CP));

 QH0(C) = CONSVAL(C)/p(C);

*Initializing variables
 QH.L(C)  = QH0(C);

DISPLAY
 P0, p, yh, beta, QH0, QH.L;

*================================================
*SOLVING FOR BASE================================
*================================================

SOLVE CPE2C USING MCP;

*================================================
*OTHER SIMULATIONS AND REPORTS===================
*================================================

*New items for simulation reports================

SET
 SIM all simulations
  /BASE, SIM1*SIM4/

 RIT report items
  /P  price
   QH quantity consumed
   CVAL consumption value/
;

DISPLAY SIM;

PARAMETER
 PQREP(RIT,C,SIM)  report on consumption (prices-quantities-values)
 ;

*Assigning report values for BASE================

 PQREP('P',C,'BASE')  = p(C);
 PQREP('QH',C,'BASE') = QH.L(C);

*Defining parameter values for non-base runs=====

PARAMETERS
*For experiments
 DP(C,SIM)  change in price of commodity c (%)
 ;
 DP('AGR-C','SIM1') = 10;
 DP('AGR-C','SIM2') = 20;
 DP('AGR-C','SIM3') = 30;
 DP('AGR-C','SIM4') = 40;

DISPLAY DP;

*SIM1============================================

 p(C) = P0(C)*(1 + DP(C,'SIM1')/100);

SOLVE CPE2C USING MCP;

 PQREP('P',C,'SIM1')     = p(C);
 PQREP('QH',C,'SIM1')    = QH.L(C);

*SIM2============================================

 p(C) = P0(C)*(1 + DP(C,'SIM2')/100);

SOLVE CPE2C USING MCP;

 PQREP('P',C,'SIM2')     = p(C);
 PQREP('QH',C,'SIM2')    = QH.L(C);

*SIM3============================================

 p(C) = P0(C)*(1 + DP(C,'SIM3')/100);

SOLVE CPE2C USING MCP;

 PQREP('P',C,'SIM3')     = p(C);
 PQREP('QH',C,'SIM3')    = QH.L(C);

*SIM4============================================

 p(C) = P0(C)*(1 + DP(C,'SIM4')/100);

SOLVE CPE2C USING MCP;

 PQREP('P',C,'SIM4')  = p(C);
 PQREP('QH',C,'SIM4') = QH.L(C);

*Transforming and displaying reports=============

 PQREP('CVAL',C,SIM) = PQREP('P',C,SIM)*PQREP('QH',C,SIM);

 OPTION DECIMALS = 2;

DISPLAY PQREP;